/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.TreeType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapSubRegion;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class TreePlanter {
    private static final int NUM_TREES_TO_SPAWN_FROM_EACH_TREE = 3;
    public static final int MAX_TREE_HEIGHT_TILES = 4;
    private Array<GridPoint2> outerOffsets = new Array(8);
    private Array<GridPoint2> innerOffsets = new Array(9);

    public TreePlanter() {
        this.outerOffsets.add(new GridPoint2(0, 6));
        this.outerOffsets.add(new GridPoint2(3, 4));
        this.outerOffsets.add(new GridPoint2(3, 1));
        this.outerOffsets.add(new GridPoint2(3, -2));
        this.outerOffsets.add(new GridPoint2(0, -3));
        this.outerOffsets.add(new GridPoint2(-3, -3));
        this.outerOffsets.add(new GridPoint2(-3, 1));
        this.outerOffsets.add(new GridPoint2(-3, 4));
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                this.innerOffsets.add(new GridPoint2(x, y));
            }
        }
    }

    public void placeTrees(GameMap map, TileSubType targetType, Random random, GameMapGenerationParams generationParams) {
        for (MapSubRegion subRegion : map.getSubRegions().values()) {
            if (!subRegion.getSubRegionType().equals((Object)targetType)) continue;
            List<TreeType> treesToUse = this.pickTreeTypesForForest(map, generationParams, subRegion, random);
            this.placeTrees(map, subRegion, random, treesToUse);
        }
    }

    private List<TreeType> pickTreeTypesForForest(GameMap map, GameMapGenerationParams generationParams, MapSubRegion subRegion, Random random) {
        ArrayList<TreeType> treesToUse = new ArrayList<TreeType>();
        float mapHeightPosition = (float)subRegion.getMiddle().y / (float)map.getHeight();
        while (treesToUse.size() < 2) {
            TreeType treeType = generationParams.getTreeTypes().get(random.nextInt(generationParams.getTreeTypes().size()));
            if (treeType.getMinYPosition() > mapHeightPosition || treeType.getMaxYPosition() < mapHeightPosition || treesToUse.contains(treeType)) continue;
            treesToUse.add(treeType);
        }
        return treesToUse;
    }

    private void placeTrees(GameMap map, MapSubRegion subRegion, Random random, List<TreeType> treesToUse) {
        LinkedList<TreeSpawnPosition> positionsToSpawnFrom = new LinkedList<TreeSpawnPosition>();
        LinkedList<GridPoint2> initialPositions = new LinkedList<GridPoint2>();
        int minX = subRegion.getMinX();
        int maxX = subRegion.getMaxX();
        int width = maxX - minX;
        int minY = subRegion.getMinY();
        int maxY = subRegion.getMaxY();
        int height = maxY - minY;
        for (int quarterX = 1; quarterX <= 3; ++quarterX) {
            for (int quarterY = 1; quarterY <= 3; ++quarterY) {
                initialPositions.add(new GridPoint2(minX + width / 4 * quarterX, minY + height / 4 * quarterY));
            }
        }
        for (GridPoint2 initialPosition : initialPositions) {
            if (!this.isTreeAllowedAt(initialPosition, map, subRegion)) continue;
            TreeType treeType = treesToUse.get(random.nextInt(treesToUse.size()));
            map.get(initialPosition).setTree(treeType);
            positionsToSpawnFrom.add(new TreeSpawnPosition(initialPosition, treeType));
        }
        block3: while (!positionsToSpawnFrom.isEmpty()) {
            TreeSpawnPosition positionToSpawnFrom = (TreeSpawnPosition)positionsToSpawnFrom.removeFirst();
            for (int treesSpawned = 0; treesSpawned < 3; ++treesSpawned) {
                GridPoint2 validNearbyPoint = null;
                for (int i = 0; i < 16 && !this.isTreeAllowedAt(validNearbyPoint = this.randomPointNear(positionToSpawnFrom.position, random), map, subRegion); ++i) {
                    validNearbyPoint = null;
                }
                if (validNearbyPoint == null) continue block3;
                map.get(validNearbyPoint).setTree(positionToSpawnFrom.treeType);
                positionsToSpawnFrom.add(new TreeSpawnPosition(validNearbyPoint, positionToSpawnFrom.treeType));
            }
        }
    }

    public GridPoint2 randomPointNear(GridPoint2 origin, Random random) {
        return origin.cpy().add(this.outerOffsets.get(random.nextInt(this.outerOffsets.size))).add(this.innerOffsets.get(random.nextInt(this.innerOffsets.size)));
    }

    public boolean isTreeAllowedAt(GridPoint2 position, GameMap map, MapSubRegion subRegionToMatch) {
        GameMapTile tile;
        int y;
        int x;
        GameMapTile tileAtPosition = map.get(position);
        if (tileAtPosition == null) {
            return false;
        }
        if (tileAtPosition.getSubRegion().getSubRegionId() != subRegionToMatch.getSubRegionId()) {
            return false;
        }
        for (x = position.x - 1; x <= position.x + 1; ++x) {
            for (y = position.y - 4; y <= position.y + 4; ++y) {
                tile = map.get(x, y);
                if (tile == null || !tile.hasTree() && !tile.hasRiver()) continue;
                return false;
            }
        }
        for (x = position.x - 1; x <= position.x + 1; ++x) {
            for (y = position.y - 1; y <= position.y + 4; ++y) {
                tile = map.get(x, y);
                if (tile != null && tile.getTileType().equals((Object)TileType.OUTSIDE)) continue;
                return false;
            }
        }
        return true;
    }

    private class TreeSpawnPosition {
        public final GridPoint2 position;
        public final TreeType treeType;

        public TreeSpawnPosition(GridPoint2 position, TreeType treeType) {
            this.position = position;
            this.treeType = treeType;
        }
    }
}

